const canvas = document.getElementById('snow');
const ctx = canvas.getContext('2d');

function resizeCanvas(){
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
}
resizeCanvas();
window.addEventListener('resize', resizeCanvas);

const snowflakes = [];
const maxFlakes = 150;

for(let i=0;i<maxFlakes;i++){
    snowflakes.push({
        x: Math.random()*canvas.width,
        y: Math.random()*canvas.height,
        r: Math.random()*4+1,
        d: Math.random()*maxFlakes,
        speed: Math.random()*1+0.5
    });
}

function drawSnow(){
    ctx.clearRect(0,0,canvas.width,canvas.height);
    ctx.fillStyle = "rgba(255,255,255,0.8)";
    ctx.beginPath();
    for(let i=0;i<maxFlakes;i++){
        const f = snowflakes[i];
        ctx.moveTo(f.x,f.y);
        ctx.arc(f.x,f.y,f.r,0,Math.PI*2,true);
    }
    ctx.fill();
    updateSnow();
}

let angle = 0;
function updateSnow(){
    angle += 0.01;
    for(let i=0;i<maxFlakes;i++){
        const f = snowflakes[i];
        f.y += Math.cos(angle + f.d) + f.speed;
        f.x += Math.sin(angle) * 2;

        if(f.x > canvas.width + 5 || f.x < -5 || f.y > canvas.height){
            f.x = Math.random()*canvas.width;
            f.y = -10;
        }
    }
}

setInterval(drawSnow,30);
